<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CampoSolicitud extends Model 
{

    protected $table = 'campos_solicitud';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tipo_solicitud_id', 'tipo_campo_solicitud_id', 'nombre', 'parent_campo_solicitud_id', 'agrupador_campo_solicitud_id');
    protected $visible = array('tipo_solicitud_id', 'tipo_campo_solicitud_id', 'nombre', 'parent_campo_solicitud_id', 'agrupador_campo_solicitud_id');

    public function tipo_campo()
    {
        return $this->belongsTo('TipoCampoSolicitud', 'tipo_campo_solicitud_id')->withTrashed();
    }

    public function tipo_solicitud()
    {
        return $this->belongsTo('TipoSolicitud', 'tipo_solicitud_id')->withTrashed();
    }

    public function parent()
    {
        return $this->belongsTo('CampoSolicitud', 'parent_campo_solicitud_id');
    }

    public function agrupador()
    {
        return $this->belongsTo('AgrupadorCampoSolicitud', 'agrupador_campo_solicitud_id');
    }

}